/*
 * libclp, a library to parse command line and rc files
 * Copyright (C) 2002 Olivier Mehani <shtrom@ssji.net>
 *
 * $Id: clp.h,v 1.2 2002/08/20 05:39:23 shtrom Exp $
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * See COPYING.
 */

/* BEGIN_C_DECLS should be used at the beginning of your declarations,
so that C++ compilers don't mangle their names.  Use END_C_DECLS at
the end of C declarations. */
#undef BEGIN_C_DECLS
#undef END_C_DECLS
#ifdef __cplusplus
# define BEGIN_C_DECLS extern "C" {
# define END_C_DECLS }
#else
# define BEGIN_C_DECLS /* empty */
# define END_C_DECLS /* empty */
#endif

/* PARAMS is a macro used to wrap function prototypes, so that
compilers that don't understand ANSI C prototypes still work,
and ANSI C compilers can issue warnings about type mismatches. */
#undef PARAMS
#if defined (__STDC__) || defined (_AIX) \
     || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
     || defined(WIN32) || defined(__cplusplus)
# define PARAMS(protos) protos
#else
# define PARAMS(protos) ()
#endif

#ifndef CLP_H
#define CLP_H 1

BEGIN_C_DECLS

#define	OPT_SINGLE 0
#define OPT_CHAR 1
#define OPT_CHAR_LIST 2
#define OPT_STRING 3
#define OPT_STRING_LIST 4
#define	OPT_INT 5
#define	OPT_INT_LIST 6
#define OPT_FLOAT 7
#define OPT_FLOAT_LIST 8

#define OPT_TYPE_SHORT 0
#define OPT_TYPE_MULTIPLE_SHORT 1
#define OPT_TYPE_LONG 2
#define OPT_TYPE_UNKNOWN 3

#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif

#ifndef NULL
#define NULL 0
#endif

struct _ClpOpt {
	char sht_opt;
	char *lng_opt;
	char *hlp_msg;
	int opt_type;
	void *var;
	int unique;
};

typedef struct _ClpOpt ClpOpt;

int clp_parse_opts PARAMS((int argc, char **argv, ClpOpt * opts, int size));
char *clp_gen_help PARAMS((ClpOpt *opts, int size, char *name));
void clp_free_help PARAMS((char *helpstring));

END_C_DECLS

#endif
