/*
 * libclp, a library to parse command line and rc files
 * Copyright (C) 2002 Olivier Mehani <shtrom@ssji.net>
 * 
 * $Id: tst.c,v 1.2 2002/08/20 05:39:23 shtrom Exp $
 * example program
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <clp.h>

int opt_help = FALSE;
char opt_char = 0;
char *opt_char_list = NULL;
char *opt_string = NULL;
char **opt_string_list = 0;
int opt_int = 0;
int *opt_int_list = NULL;
float opt_float = 0;
float *opt_float_list = NULL;

ClpOpt opts1[] = {
	{'h', "help", "\tThis message", OPT_SINGLE, &opt_help, TRUE},
	{'c', "char", "\tTest the char options", OPT_CHAR, &opt_char, FALSE},
	{'C', "charlist", "Test the char list options", OPT_CHAR_LIST,
	 &opt_char_list, FALSE},
	{'s', "string", "\tTest the string options", OPT_STRING, &opt_string,
	 FALSE},
	{'S', "stringlist", "Test the string list options", OPT_STRING_LIST,
	 &opt_string_list, FALSE},
	{'i', "int", "\tTest the int options", OPT_INT, &opt_int, FALSE},
	{'I', "intlist", "\tTest the int list options", OPT_INT_LIST,
	 &opt_int_list, FALSE},
	{'f', "float", "\tTest the float options", OPT_FLOAT, &opt_float,
	 FALSE},
	{'F', "floatlist", "Test the float list options", OPT_FLOAT_LIST,
	 &opt_float_list, FALSE}
};

int size1 = sizeof(opts1) / sizeof(ClpOpt);

int main(int argc, char **argv)
{
	char *helpstring, *curcl, **cursl;
	int result, *curil;
	float *curfl;

	result = clp_parse_opts(argc, argv, opts1, size1);
	if (result > 0) {
		printf("Unknown option: %s\n", argv[result]);
		exit(1);
	} else if (result < 0) {
		printf("Option needs an argument: %s\n", argv[-result]);
		exit(1);
	}

	if (opt_help) {
		printf("%s\n", helpstring = clp_gen_help(opts1, size1, argv[0]));
		clp_free_help(helpstring);
		exit(1);
	}
	if (opt_char)
		printf("char: %c\n", opt_char);
	if (opt_char_list) {
		printf("charlist:\n");
		curcl = opt_char_list;
		while (*curcl) {
			printf(" %c\n", *curcl);
			curcl++;
		}
	}
	if (opt_string)
		printf("string: %s\n", opt_string);
	if (opt_string_list) {
		printf("stringlist:\n");
		cursl = opt_string_list;
		while (*cursl) {
			printf(" %s\n", *cursl);
			cursl++;
		}
	}
	if (opt_int)
		printf("int: %i\n", opt_int);
	if (opt_int_list) {
		printf("intlist:\n");
		curil = opt_int_list;
		while (*curil!=-1) {
			printf(" %i\n",*curil);
			curil++;
		}
	}
	if (opt_float)
		printf("float: %f\n", opt_float);
	if (opt_float_list) {
		printf("floatlist:\n");
		curfl = opt_float_list;
		while (*curfl!=-1) {
			printf(" %f\n", *curfl);
			curfl++;
		}
	}
	return 0;
}
