#!/bin/sh
#	install.sh
#
#	install script for araw, for details, refer to the README file
#
#							Olivier Mehani, 2002
#							   <shtrom@ssji.net>
#
#	$Revision: 1.8 $
#	$Date: 2002/11/10 21:10:47 $
#

#The directories, by default they are those of my Slackware
#You MUST edit them to fit you distro's ones
#NO trailing slash !
pppdir="/etc/ppp"			#where does your pppd config files live ?
startupdir="/etc/rc.d"			#where should I put the startup files
rclocal="${startupdir}/rc.local"	#where should I had a line to call my startup files (the file will be created if non existent)
mrunpath="/usr/local/bin/modem_run"	#the modem_run util that comes along with the driver
mgmt="${pppdir}/mgmt.o"			#your mgmt.o file
pppoa="pppoa2"				#the pppoa you'r using (may be pppoa2 or pppoa3)

#generate the strings to feed sed while relpacing
echo $pppdir | sed "s/\//\\\\\//g" > tmp
sedpppdir=`cat tmp`
echo $startupdir | sed "s/\//\\\\\//g" > tmp
sedstartupdir=`cat tmp`
echo $rclocal | sed "s/\//\\\\\//g" > tmp
sedrclocal=`cat tmp`
echo $mrunpath | sed "s/\//\\\\\//g" > tmp
sedmrunpath=`cat tmp`
echo $mgmt | sed "s/\//\\\\\//g" > tmp
sedmgmt=`cat tmp`
echo $pppoa | sed "s/\//\\\\\//g" > tmp
sedpppoa=`cat tmp`
rm tmp

sedcmd="sed -e s/###PPPDIR###/${sedpppdir}/ -e s/###STARTUPDIR###/${sedstartupdir}/ -e s/###MRUNPATH###/${sedmrunpath}/ -e s/###MGMT###/${sedmgmt}/ -e s/###PPPOA###/${sedpppoa}/"
cpcmd="cp -i -v"

echo "ARAW 0.5 install script"
echo
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!WARNING!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "This install script is configured by default for MY system, make sure you have"
echo "edited the paths to match YOUR system."
echo
echo "	Your pppd config is in ${pppdir}"
echo "	Your startup dir is ${startupdir}"
echo "	Your rc.local script is ${rclocal}"
echo
echo "	Your modem_run util is ${mrunpath}"
echo "	Your mgmt.o file is ${mgmt}"
echo "	You are using ${pppoa}"
echo
echo "You have 5 seconds to hit Ctrl+C to stop the process"
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!WARNING!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
sleep 5
echo "OK, let's go..."

oldfile=".old."`date +%Y%m%d%H%M%S`

echo
echo "Installing files in ${pppdir}"
for file in ppp-go ip-up ip-check araw-up araw-down routing-up routing-down; do
    if [ -e ${pppdir}/${file} ]; then
	echo Saving ${pppdir}/${file} to ${pppdir}/${file}${oldfile}
	mv ${pppdir}/${file} ${pppdir}/${file}${oldfile}
    fi
    echo "${file} -> ${pppdir}/${file}"
    cat ${file} | ${sedcmd} > ${pppdir}/${file}
    chmod 755 ${pppdir}/${file}
done

echo
echo "Installing files in ${startupdir}"
for file in rc.adsl ppp-at ppp-kill-at; do
    if [ -e ${startupdir}/${file} ]; then
	echo Saving ${startupdir}/${file} to ${startupdir}/${file}${oldfile}
	mv ${startupdir}/${file} ${startupdir}/${file}${oldfile}
    fi
    echo "${file} -> ${pppdir}/${file}"
    cat ${file} | ${sedcmd} > ${startupdir}/${file}
done

echo
if [ ! -f ${rclocal} ] ; then
    echo "${rclocal} doesn't exist, creating it" 
    echo "WARNING : If you have a SysV style init (most distribution do), consider doing a ln -s ${rclocal} /path/to/startup/scripts/for/this/runlevel/S99rc.local"
    echo "#!/bin/sh\n" > ${rclocal}
    echo "#	This file has been created by ARAW's install script" > ${rclocal}
    echo "# 	It is intended to start applications at the very end of your" > ${rclocal}
    echo "#	computer's startup process" > ${rclocal}
    echo "#	WARNING : If you have a SysV style init (most distribution do), consider" > ${rclocal}
    echo "#	doing a" > ${rclocal}
    echo "#	ln -s ${rclocal} /path/to/startup/scripts/for/this/runlevel/S99rc.local" > ${rclocal}
fi
  
grep "${startupdir}/rc.adsl" ${rclocal} 2>&1 >/dev/null
if [ "$?" != "0" ]; then
    echo "Adding a call to ${startupdir}/rc.adsl in ${rclocal}" 
    echo -e "\n${startupdir}/rc.adsl\n" >> ${rclocal}
else
    echo "An existing call to ${startupdir}/rc.adsl has been found in in ${rclocal}"
fi
echo
echo "Done... Now pray and reboot ;-)"
